<?php
session_start();

// Verificar si el usuario está autenticado
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: login.php');
    exit;
}

// Directorio de anuncios
$directorio = "ads/";

// Eliminar imagen si se recibe solicitud
if (isset($_GET['eliminar'])) {
    $imagenEliminar = basename($_GET['eliminar']);
    $ruta = $directorio . $imagenEliminar;

    if (file_exists($ruta)) {
        unlink($ruta);
        $mensaje = "Imagen eliminada exitosamente.";
    } else {
        $mensaje = "La imagen no existe.";
    }
    // Redirigir automáticamente a anuncios.php
header("Location: ver-ads.php");
exit;
}

// Obtener lista de imágenes
$imagenes = glob($directorio . "*.{jpg,jpeg,png,gif}", GLOB_BRACE);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Gestionar Anuncios</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

    <!-- Navbar -->
    <?php include 'navbar.php'; ?>

<div class="content-wrapper">
    <section class="content-header">
        <h1>Gestionar Anuncios</h1>
    </section>

    <section class="content">

        <?php if (isset($mensaje)): ?>
            <div class="alert alert-info"><?= $mensaje ?></div>
        <?php endif; ?>

        <div class="row">
            <?php if (!empty($imagenes)): ?>
                <?php foreach ($imagenes as $imagen): ?>
                    <div class="col-md-3 mb-4">
                        <div class="card">
                            <img src="<?= $imagen ?>" class="card-img-top" style="height: 200px; object-fit: cover;">
                            <div class="card-body text-center">
                                <a href="?eliminar=<?= urlencode(basename($imagen)) ?>" class="btn btn-danger btn-sm" onclick="return confirm('¿Estás seguro de eliminar esta imagen?')">Eliminar</a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="alert alert-warning">No hay imágenes subidas aún.</div>
            <?php endif; ?>
        </div>

    </section>
</div>

</body>
</html>
