<?php
session_start();

// Verificamos si el usuario está autenticado
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: login.php');
    exit;
}

// Definir el directorio donde se guardará la imagen subida
$uploadDir = 'uploads/';
$uploadFile = $uploadDir . 'image.jpg'; // El nombre del archivo de la imagen

// Comprobar si se ha enviado una imagen
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_FILES['image'])) {
    $file = $_FILES['image'];

    // Comprobamos si la subida fue exitosa
    if ($file['error'] == 0) {
        // Validar tipo de archivo (solo imágenes)
        $allowedTypes = ['image/jpeg', 'image/png', 'image/gif'];
        if (in_array($file['type'], $allowedTypes)) {
            // Mover el archivo subido al directorio deseado
            if (move_uploaded_file($file['tmp_name'], $uploadFile)) {
                echo "<div class='alert alert-success'>¡Imagen subida correctamente!</div>";
            } else {
                echo "<div class='alert alert-danger'>Error al mover la imagen. Intente nuevamente.</div>";
            }
        } else {
            echo "<div class='alert alert-danger'>El archivo debe ser una imagen (JPEG, PNG o GIF).</div>";
        }
    } else {
        echo "<div class='alert alert-danger'>Hubo un error en la subida del archivo. Intente nuevamente.</div>";
    }
}

// Verificar si ya existe una imagen subida
$imageUrl = file_exists($uploadFile) ? $uploadFile : '';
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Subir Imagen</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="styles.css"> <!-- Incluimos el archivo CSS -->
</head>
<body class="bg-light">

    <!-- Navbar -->
    <?php include 'navbar.php'; ?>

    <div class="container mt-5">
        <h1 class="text-center">Subir Imagen</h1>

        <!-- Formulario para subir imagen -->
        <form action="upload_image.php" method="POST" enctype="multipart/form-data">
            <div class="mb-3">
                <label for="image" class="form-label">Selecciona una imagen</label>
                <input type="file" class="form-control" id="image" name="image" required>
            </div>
            <button type="submit" class="btn btn-primary">Subir Imagen</button>
        </form>

        <!-- Mostrar la imagen si ya está subida -->
        <?php if ($imageUrl): ?>
            <div class="mt-4 text-center">
                <h3>Imagen Subida:</h3>
                <img src="<?php echo $imageUrl; ?>" alt="Imagen Subida" class="img-fluid" style="max-width: 100%; height: auto;">
            </div>
        <?php else: ?>
            <p class="text-center">No hay imagen subida aún.</p>
        <?php endif; ?>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
