<?php
session_start();

// Verificar si el usuario está autenticado
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: login.php');
    exit;
}

// Lógica para actualizar las credenciales
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Verificar si el formulario tiene datos válidos
    if (!empty($_POST['new_user']) && !empty($_POST['new_pass'])) {
        // Obtener el nuevo usuario y la nueva contraseña
        $newUser = $_POST['new_user'];
        $newPass = $_POST['new_pass'];

        // Guardar las nuevas credenciales en el archivo config.txt
        $configContent = "user=$newUser\npassword=$newPass";

        // Guardar el archivo actualizado
        file_put_contents('user_config.txt', $configContent);

        // Redirigir a la página del panel después de actualizar
        header('Location: panel.php');
        exit;
    } else {
        $errorMessage = "Por favor, ingrese un nuevo nombre de usuario y una nueva contraseña.";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Actualizar Usuario y Contraseña</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
    <!-- Incluir el Navbar -->
    <?php include 'navbar.php'; ?>

    <div class="container mt-5">
        <h1 class="text-center">Actualizar Usuario y Contraseña</h1>

        <!-- Mostrar mensaje de error si existe -->
        <?php if (isset($errorMessage)): ?>
            <div class="alert alert-danger">
                <?php echo $errorMessage; ?>
            </div>
        <?php endif; ?>

        <!-- Formulario para actualizar las credenciales -->
        <form method="POST" action="update_user.php">
            <div class="mb-3">
                <label for="new_user" class="form-label">Nuevo Usuario</label>
                <input type="text" name="new_user" id="new_user" class="form-control" required>
            </div>
            <div class="mb-3">
                <label for="new_pass" class="form-label">Nueva Contraseña</label>
                <input type="password" name="new_pass" id="new_pass" class="form-control" required>
            </div>
            <button type="submit" class="btn btn-primary w-100">Actualizar Credenciales</button>
        </form>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
