<?php
session_start();

// Verificamos si el usuario está autenticado
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: login.php');
    exit;
}

// Lógica para agregar la URL
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $url = trim($_POST['url']);
    $title = trim($_POST['title']);

    // Verificamos si la URL y el título no están vacíos
    if (!empty($url) && !empty($title)) {
        $urlsFile = 'urls.php';
        $titlesFile = 'titles.php';

        // Obtenemos las URLs existentes
        $existingUrls = file_exists($urlsFile) ? file_get_contents($urlsFile) : '';
        $existingTitles = file_exists($titlesFile) ? file_get_contents($titlesFile) : '';

        // Evitamos comas al final y verificamos si ya existe la URL
        if (!empty($existingUrls)) {
            $existingUrls = rtrim($existingUrls, ', ') . ', ';
        }

        // Formateamos la nueva entrada
        $newUrlEntry = $url;
        $newTitleEntry = $title;

        // Si el archivo está vacío, no agregamos la coma extra
        $newUrlsContent = empty($existingUrls) ? $newUrlEntry : $existingUrls . $newUrlEntry;
        $newTitlesContent = empty($existingTitles) ? $newTitleEntry : $existingTitles . $newTitleEntry;

        // Guardamos las URLs y los títulos en sus archivos correspondientes
        file_put_contents($urlsFile, $newUrlsContent . ', ');
        file_put_contents($titlesFile, $newTitlesContent . ', ');

        // Redirigir de vuelta al panel
        header('Location: panel.php');
        exit;
    } else {
        $errorMessage = "Por favor, ingrese tanto el título como la URL.";
    }
}
?>
