<?php
session_start();

// Verificar si el usuario está autenticado
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: login.php');
    exit;
}

// Cargar los títulos y las URLs desde los archivos
$titlesFile = 'titles.php';
$urlsFile = 'urls.php';

$titles = file_exists($titlesFile) ? file_get_contents($titlesFile) : '';
$urls = file_exists($urlsFile) ? file_get_contents($urlsFile) : '';

// Convertir los títulos y las URLs a arrays
$titlesArray = explode(', ', rtrim($titles, ', '));
$urlsArray = explode(', ', rtrim($urls, ', '));

// Emparejar los títulos con las URLs
$urlsData = array();
for ($i = 0; $i < count($titlesArray); $i++) {
    $urlsData[] = array(
        'title' => $titlesArray[$i],
        'url' => isset($urlsArray[$i]) ? $urlsArray[$i] : ''
    );
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Panel de Gestión de URLs</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
    <!-- Incluir el Navbar -->
    <?php include 'navbar.php'; ?>

    <div class="container mt-5">
        <h1 class="text-center">Gestión de URLs</h1>

        <!-- Botón para agregar nueva URL y título -->
        <h2 class="mt-4">Agregar Nueva URL</h2>
        <p>Para agregar una nueva URL y título, haz clic <a href="add_url.php">aquí</a>.</p>

        <!-- Mostrar URLs almacenadas con sus títulos -->
        <h2 class="mt-4">URLs Guardadas</h2>
        <ul class="list-group">
            <?php foreach ($urlsData as $data): ?>
                <?php if (!empty($data['title']) && !empty($data['url'])): ?>
                    <li class="list-group-item d-flex justify-content-between">
                        <strong><?php echo htmlspecialchars($data['title']); ?></strong> <?php echo htmlspecialchars($data['url']); ?>
                        <a href="edit_url.php?url=<?php echo urlencode($data['url']); ?>" class="btn btn-warning btn-sm">Editar</a>
                        <a href="delete_url.php?url=<?php echo urlencode($data['url']); ?>" class="btn btn-danger btn-sm">Eliminar</a>
                    </li>
                <?php endif; ?>
            <?php endforeach; ?>
        </ul>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
