<?php
session_start();

// Verificar si el usuario ya está autenticado
if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true) {
    header('Location: panel.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Leer las credenciales almacenadas en config.txt
    $configContent = file_get_contents('user_config.txt');
    $configArray = parse_ini_string($configContent);

    $storedUser = $configArray['user'];
    $storedPass = $configArray['password'];

    // Obtener los valores ingresados por el usuario
    $username = $_POST['username'];
    $password = $_POST['password'];

    // Verificar las credenciales
    if ($username === $storedUser && $password === $storedPass) {
        $_SESSION['loggedin'] = true;
        $_SESSION['username'] = $username;
        header('Location: panel.php');
        exit;
    } else {
        $errorMessage = "Nombre de usuario o contraseña incorrectos.";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Iniciar sesión</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container mt-5">
        <h1 class="text-center">Iniciar sesión</h1>

        <!-- Mostrar mensaje de error si existe -->
        <?php if (isset($errorMessage)): ?>
            <div class="alert alert-danger">
                <?php echo $errorMessage; ?>
            </div>
        <?php endif; ?>

        <!-- Formulario de login -->
        <form method="POST" action="login.php">
            <div class="mb-3">
                <label for="username" class="form-label">Usuario</label>
                <input type="text" name="username" id="username" class="form-control" required>
            </div>
            <div class="mb-3">
                <label for="password" class="form-label">Contraseña</label>
                <input type="password" name="password" id="password" class="form-control" required>
            </div>
            <button type="submit" class="btn btn-primary w-100">Iniciar sesión</button>
        </form>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
