<?php
header('Content-Type: text/html; charset=utf-8');

function getMoviesFromEndpoint($api_key, $pages = 1) {
    $cache_file = 'movies_cache.json';
    $cache_time = 3600;
    $userAgent = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36';

    if (file_exists($cache_file) && (time() - filemtime($cache_file) < $cache_time)) {
        return json_decode(file_get_contents($cache_file), true);
    }

    $movies = [];
    for ($page = 1; $page <= $pages; $page++) {
        $url = "https://api.themoviedb.org/3/movie/now_playing?api_key={$api_key}&language=es-ES&page={$page}";
        $context = stream_context_create([
            'http' => [
                'header' => "User-Agent: $userAgent\r\n"
            ]
        ]);
        $response = file_get_contents($url, false, $context);
        $data = json_decode($response, true);
        if (isset($data['results']) && is_array($data['results'])) {
            $movies = array_merge($movies, $data['results']);
        }
    }

    $movies = array_filter($movies, function($movie) {
        return isset($movie['backdrop_path']) && $movie['backdrop_path'] !== null;
    });

    file_put_contents($cache_file, json_encode($movies));
    return $movies;
}

$api_key = '224bb76d69355b445dde71c1069688e5';
$movies = array_values(getMoviesFromEndpoint($api_key)); // reindexar
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Carrusel Fullscreen</title>
    
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body, html { height: 100%; font-family: Arial, sans-serif; overflow: hidden;   }
 
        .slide {
            position: absolute;
            width: 100%;
            height: 100%;
            background-size: cover;
            background-position: center center;
            opacity: 0;
            transition: opacity 1s ease-in-out;
        }
.slide::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: linear-gradient(to bottom, rgba(255,255,255,0) 25%, rgba(0,0,0,0.8) 80%);
    z-index: 0;
}
        .slide.active {
            opacity: 1;
            z-index: 1;
        }

   .overlay {
    position: fixed;
    bottom: 35%;
    left: 10%;
    background: rgba(0, 0, 0, 0.6);
    padding: 10px;
    border-radius: 8px;
    color: white;
    max-width: 100%;
    max-height: 140px;
    width: 600px;
}
        .overlay h1 {
            font-size: 20px;
            margin-bottom: 5px;
        }

        .overlay p {
            font-size: 12px;
        }
    
@media (min-width: 1900px) and (max-width: 2000px) {
  /* Estilos para pantallas de 24 pulgadas */
  body {
    font-size: 18px;
  }
    .overlay {
        position: fixed;
        bottom: 35%;
        left: 15%;
        background: rgba(0, 0, 0, 0.6);
        padding: 10px;
        border-radius: 8px;
        color: white;
       max-width: 100%;
        width: 850px;
            max-height: 155px;
    }
.overlay h1 {
    font-size: 30px;
    margin-bottom: 5px;
}
.overlay p {
    font-size: 22px;
    line-height: 1.5em;
    overflow: hidden;
    text-overflow: ellipsis;
    max-height: calc(0.45em * 10);

}
}

@media (min-width: 2500px) and (max-width: 2700px) {
  /* Estilos para pantallas de 27 pulgadas */
  body {
    font-size: 20px;
  }
        .overlay {
        position: fixed;
        bottom: 35%;
        left: 15%;
        background: rgba(0, 0, 0, 0.6);
        padding: 10px;
        border-radius: 8px;
        color: white;
        max-width: 100%;
        width: 850px;
         max-height: 155px;
}
.overlay h1 {
    font-size: 30px;
    margin-bottom: 5px;
}
.overlay p {
    font-size: 22px;
    line-height: 1.5em;
    overflow: hidden;
    text-overflow: ellipsis;
    max-height: calc(0.45em * 10);

}
}

    </style>

    
    
</head>   

<body >
   
<iframe src="./ads.php" frameborder="0"  style="position: fixed; top: 12%; right: 80px; width: 100%; height: 800px; border: none; background: transparent; border-radius: 15px; z-index: 9999;"  allowtransparency="true"></iframe>

<?php foreach ($movies as $index => $movie): ?>
    <div class="slide<?= $index === 0 ? ' active' : '' ?>" style="background-image: url('https://image.tmdb.org/t/p/original<?= $movie['backdrop_path'] ?>');">
       <!-- Iframe que carga otro contenido (por ejemplo, un slider de anuncios) -->


            <div class="overlay">
            
            <h1><?= htmlspecialchars($movie['title']) ?></h1>
         
            <p><?= htmlspecialchars($movie['overview']) ?></p>
        </div>
    </div>
<?php endforeach; ?>

<script>
    const slides = document.querySelectorAll('.slide');
    let currentSlide = 0;
    const delay = 3000; // 5 segundos

    setInterval(() => {
        slides[currentSlide].classList.remove('active');
        currentSlide = (currentSlide + 1) % slides.length;
        slides[currentSlide].classList.add('active');
    }, delay);
</script>

</body>
</html>
