<?php
session_start();

// Verificamos si el usuario está autenticado
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: login.php');
    exit;
}

// Comprobamos si recibimos el parámetro de URL que queremos editar
if (isset($_GET['url'])) {
    $urlToEdit = $_GET['url'];

    // Cargar las URLs y los títulos desde los archivos
    $urlsFile = 'urls.php';
    $titlesFile = 'titles.php';

    $urls = file_exists($urlsFile) ? file_get_contents($urlsFile) : '';
    $titles = file_exists($titlesFile) ? file_get_contents($titlesFile) : '';

    // Convertir las URLs y los títulos en arrays
    $urlsArray = explode(', ', rtrim($urls, ', '));
    $titlesArray = explode(', ', rtrim($titles, ', '));

    // Encontrar la posición de la URL que queremos editar
    $index = array_search($urlToEdit, $urlsArray);

    if ($index === false) {
        die('URL no encontrada');
    }

    // Obtener el título correspondiente a esta URL
    $currentTitle = $titlesArray[$index];
} else {
    die('No se especificó ninguna URL para editar');
}

// Lógica para guardar los cambios
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $newTitle = trim($_POST['title']);
    $newUrl = trim($_POST['url']);

    // Verificamos que no estén vacíos
    if (!empty($newTitle) && !empty($newUrl)) {
        // Actualizamos las URL y el título en los arrays
        $urlsArray[$index] = $newUrl;
        $titlesArray[$index] = $newTitle;

        // Convertimos los arrays de nuevo a cadenas separadas por comas
        $newUrlsContent = implode(', ', $urlsArray);
        $newTitlesContent = implode(', ', $titlesArray);

        // Guardamos las URLs y los títulos actualizados en los archivos
        file_put_contents($urlsFile, $newUrlsContent . ', ');
        file_put_contents($titlesFile, $newTitlesContent . ', ');

        // Redirigimos al panel después de guardar
        header('Location: panel.php');
        exit;
    } else {
        $errorMessage = "Por favor, ingrese tanto el título como la URL.";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar URL</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

    <!-- Navbar -->
    <?php include 'navbar.php'; ?>

    <div class="container mt-5">
        <h1 class="text-center">Editar URL</h1>

        <!-- Mostrar mensaje de error si existe -->
        <?php if (isset($errorMessage)): ?>
            <div class="alert alert-danger">
                <?php echo $errorMessage; ?>
            </div>
        <?php endif; ?>

        <!-- Formulario para editar título y URL -->
        <form method="POST" action="edit_url.php?url=<?php echo urlencode($urlToEdit); ?>">
            <div class="mb-3">
                <label for="title" class="form-label">Título de la URL</label>
                <input type="text" name="title" id="title" class="form-control" value="<?php echo htmlspecialchars($currentTitle); ?>" required>
            </div>
            <div class="mb-3">
                <label for="url" class="form-label">URL</label>
                <input type="url" name="url" id="url" class="form-control" value="<?php echo htmlspecialchars($urlToEdit); ?>" required>
            </div>
            <button type="submit" class="btn btn-primary w-100">Guardar Cambios</button>
        </form>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
