<?php
session_start();

// Verificamos si el usuario está autenticado
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: login.php');
    exit;
}

if (isset($_GET['url'])) {
    $urlToDelete = urldecode($_GET['url']);

    // Leer las URLs actuales desde el archivo
    $file = 'urls.php';
    $urls = file_exists($file) ? file_get_contents($file) : '';
    $urlsArray = explode(', ', rtrim($urls, ', '));

    // Eliminar la URL seleccionada
    $urlsArray = array_filter($urlsArray, function($url) use ($urlToDelete) {
        return $url !== $urlToDelete;
    });

    // Guardar las URLs actualizadas sin la URL eliminada
    $newUrls = implode(', ', $urlsArray);
    file_put_contents($file, $newUrls . ', ');

    // Redirigir de vuelta al panel después de eliminar la URL
    header('Location: panel.php');
    exit;
}
?>
