<?php
session_start();

// Verificamos si el usuario está autenticado
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: login.php');
    exit;
}

$mensaje = '';  // Inicializamos la variable del mensaje de estado

// Procesamiento de imágenes
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_FILES['imagenes'])) {
    $directorio = "ads/";

    // Verificamos si el directorio existe, si no, lo creamos
    if (!is_dir($directorio)) {
        mkdir($directorio, 0777, true);
    }

    // Iteramos sobre las imágenes subidas
    foreach ($_FILES['imagenes']['tmp_name'] as $key => $tmp_name) {
        $nombreArchivo = basename($_FILES['imagenes']['name'][$key]);
        $rutaDestino = $directorio . $nombreArchivo;

        // Intentamos mover la imagen a la carpeta destino
        if (move_uploaded_file($tmp_name, $rutaDestino)) {
            $mensaje = "Imagen subida con éxito: $nombreArchivo";  // Mensaje de éxito
        } else {
            $mensaje = "Error al subir la imagen: $nombreArchivo";  // Mensaje de error
        }
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Subir Anuncios</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="styles.css"> <!-- Incluimos el archivo CSS -->
</head>
<body class="bg-light">

    <!-- Navbar -->
    <?php include 'navbar.php'; ?>
 <div class="container mt-5">
    <div class="content-wrapper">
        <section class="content-header">
            <h1>Subir Anuncios</h1>
        </section>

        <section class="content">
            <!-- Mostrar el mensaje de éxito o error si se ha subido la imagen -->
            <?php if ($mensaje): ?>
                <div class="alert alert-info">
                    <?php echo $mensaje; ?>
                </div>
            <?php endif; ?>

            <!-- Formulario de subida de imágenes -->
            <form action="procesar_anuncios.php" method="POST" enctype="multipart/form-data">
                <div class="form-group">
                    <label for="imagenes">Selecciona las imágenes:</label>
                    <input type="file" name="imagenes[]" multiple accept="image/*" class="form-control" required>
                </div>
                <button type="submit" class="btn btn-primary">Subir</button>
            </form>
        </section>
    </div>    </div>
</body>
</html>
