<?php
session_start();

// Verificar si el usuario está autenticado
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: login.php');
    exit;
}

// Lógica para agregar la URL y título
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $url = trim($_POST['url']);
    $title = trim($_POST['title']);

    // Verificamos si la URL y el título no están vacíos
    if (!empty($url) && !empty($title)) {
        // Guardar el título en titles.php
        $titlesFile = 'titles.php';
        $titles = file_exists($titlesFile) ? file_get_contents($titlesFile) : '';
        $newTitleEntry = $title;
        $newTitlesContent = $titles ? $titles . ", " . $newTitleEntry : $newTitleEntry;
        file_put_contents($titlesFile, $newTitlesContent);

        // Guardar la URL en urls.php
        $urlsFile = 'urls.php';
        $urls = file_exists($urlsFile) ? file_get_contents($urlsFile) : '';
        $newUrlEntry = $url;
        $newUrlsContent = $urls ? $urls . ", " . $newUrlEntry : $newUrlEntry;
        file_put_contents($urlsFile, $newUrlsContent);

        // Redirigir al panel después de agregar la URL
        header('Location: panel.php');
        exit;
    } else {
        $errorMessage = "Por favor, ingrese un título y una URL.";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Agregar URL</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

    <!-- Navbar -->
    <?php include 'navbar.php'; ?>

    <div class="container mt-5">
        <h1 class="text-center">Agregar Nueva URL</h1>

        <!-- Mostrar mensaje de error si existe -->
        <?php if (isset($errorMessage)): ?>
            <div class="alert alert-danger">
                <?php echo $errorMessage; ?>
            </div>
        <?php endif; ?>

        <!-- Formulario para agregar URL y título -->
        <form method="POST" action="add_url.php">
            <div class="mb-3">
                <label for="title" class="form-label">Título de la URL</label>
                <input type="text" name="title" id="title" class="form-control" required>
            </div>
            <div class="mb-3">
                <label for="url" class="form-label">URL</label>
                <input type="url" name="url" id="url" class="form-control" required>
            </div>
            <button type="submit" class="btn btn-primary w-100">Agregar URL</button>
        </form>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
